package demo.forms;

import java.io.*;
import java.util.Vector;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import de.kxml.kdom.*;
import de.kxml.parser.*;
import demo.*;

/**
 * Ecran de recherche des informations  partir du type 
 * d'information, du titre et du contenu
 */
public class QueryForm extends Form implements CommandListener, IState{
  // Champ Type d'information
  private ChoiceGroup type;
  // Champ Titre de l'information
  private TextField titre;
  // Champ Contenu de l'information
  private TextField contenu;
  // Commande de soumission de la requte 
  private Command submit;
  // Rfrence au contenu de la machine d'tat
  private IStateMachine parent;

  /**
   * Constructeur bas sur un QueryForm avec le nom spcifi et le 
   * IstateMachine parent
   */
  public QueryForm(String name, IStateMachine parent) {
    super(name);
    this.parent = parent;
    // Cre l'cran
    this.type = new ChoiceGroup ("Type", Choice.EXCLUSIVE);
    this.type.append ("Client", null);
    this.type.append ("Fournisseur", null);
    this.type.append ("Partenaire", null);
    this.type.append ("Prospect", null);
    this.type.append ("Autre", null);
    this.titre = new TextField("Titre", null, 16, TextField.ANY);
    this.contenu = new TextField("Contenu", null, 16, TextField.ANY);
    this.submit = new Command("Lance", Command.SCREEN, 1);
    this.append(this.type);
    this.append(this.titre);
    this.append(this.contenu);
    this.addCommand(this.submit);
    this.setCommandListener(this);
  }
  /**
   * Appelle setCurrentState() dans la machine d'tat pour mettre
   *  jour l'tat en fonction de la commande actionne
   */
  public void commandAction(Command c, Displayable d) {
    Vector infoLinks = null;
    try {
      int selection = this.type.getSelectedIndex();
      infoLinks = RemoteServices.getInstance().getResults(this.type.getString(selection), this.titre.getString(), this.contenu.getString());
      this.parent.setCurrentState(kb.STATE_QUERY_RESULTS, infoLinks);
    } catch (IOException ex) {
      Alert remoteAlert = new Alert("Erreur rseau ", "Message: " + ex.getMessage(), null, AlertType.ERROR);
      remoteAlert.setTimeout(5000);
      Display.getDisplay((MIDlet) parent).setCurrent(remoteAlert);
    } catch (Throwable t) {
      System.out.println(t.getMessage());
      t.printStackTrace();
    }
  }

  /**
   * Pas de changement d'tat
   */
  public void handleTransition(Object eventData) {
  }
}
